<?php 
$pageTitle = 'Cloud Services';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">Cloud & DevOps</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Infraestructura indestructible. Escalabilidad automática y seguridad de nivel empresarial.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16 items-center">
                <div>
                    <h2 class="text-3xl font-bold mb-6">Arquitectura en la Nube</h2>
                    <p class="text-gray-400 text-lg leading-relaxed mb-8">No solo alojamos su web; diseñamos ecosistemas en la nube resilientes. Expertos en AWS, Google Cloud y Azure.</p>
                    
                    <div class="grid grid-cols-1 gap-4">
                        <div class="p-6 rounded-2xl bg-[#0a0a0a] border border-white/10 flex items-center gap-6">
                            <i class="fa-brands fa-aws text-4xl text-white"></i>
                            <div>
                                <h4 class="font-bold">AWS Certified</h4>
                                <p class="text-sm text-gray-500">Expertos en Lambda, EC2 y S3.</p>
                            </div>
                        </div>
                        <div class="p-6 rounded-2xl bg-[#0a0a0a] border border-white/10 flex items-center gap-6">
                            <i class="fa-brands fa-docker text-4xl text-blue-500"></i>
                            <div>
                                <h4 class="font-bold">Containerización</h4>
                                <p class="text-sm text-gray-500">Despliegues consistentes con Docker y K8s.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative">
                    <div class="absolute inset-0 bg-brand-orange/20 blur-[100px] rounded-full"></div>
                    <div class="relative z-10 p-8 rounded-3xl bg-brand-black border border-white/10">
                        <div class="flex items-center gap-2 mb-6">
                            <div class="w-3 h-3 rounded-full bg-red-500"></div>
                            <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                            <div class="w-3 h-3 rounded-full bg-green-500"></div>
                        </div>
                        <div class="font-mono text-sm space-y-2">
                            <p class="text-green-400">$ terraform apply</p>
                            <p class="text-gray-500">Plan: 12 to add, 0 to change, 0 to destroy.</p>
                            <p class="text-gray-300">aws_instance.web: Creating...</p>
                            <p class="text-gray-300">aws_db_instance.db: Creating...</p>
                            <p class="text-brand-orange font-bold mt-4">✓ Infrastructure as Code Ready</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
