<?php 
$pageTitle = 'Empleo';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">Únete al Equipo</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Buscamos mentes brillantes apasionadas por la tecnología y los retos de ingeniería.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-5xl mx-auto px-4">
            <div class="space-y-6">
                <!-- Job 1 -->
                <div class="p-8 rounded-2xl bg-[#0a0a0a] border border-white/10 flex flex-col md:flex-row justify-between items-start md:items-center gap-6 group hover:border-brand-orange/50 transition-colors">
                    <div>
                        <h3 class="text-2xl font-bold mb-1">Fullstack Developer</h3>
                        <p class="text-gray-500 text-sm">Remoto / Híbrido (Riohacha) • Senior • Full-time</p>
                    </div>
                    <a href="https://wa.me/573000000000?text=Hola,%20me%20interesa%20la%20vacante%20de%20Fullstack" class="px-6 py-3 bg-white text-black font-bold uppercase text-xs tracking-widest rounded-lg hover:bg-brand-orange hover:text-white transition-colors">Aplicar Ahora</a>
                </div>

                <!-- Job 2 -->
                <div class="p-8 rounded-2xl bg-[#0a0a0a] border border-white/10 flex flex-col md:flex-row justify-between items-start md:items-center gap-6 group hover:border-brand-orange/50 transition-colors">
                    <div>
                        <h3 class="text-2xl font-bold mb-1">UX/UI Designer</h3>
                        <p class="text-gray-500 text-sm">Remoto • Mid-Level • Freelance/Full-time</p>
                    </div>
                    <a href="https://wa.me/573000000000?text=Hola,%20me%20interesa%20la%20vacante%20de%20Designer" class="px-6 py-3 bg-white text-black font-bold uppercase text-xs tracking-widest rounded-lg hover:bg-brand-orange hover:text-white transition-colors">Aplicar Ahora</a>
                </div>

                <!-- Spontaneous -->
                <div class="mt-16 text-center p-12 rounded-3xl bg-brand-orange/5 border border-brand-orange/20">
                    <h3 class="text-2xl font-bold mb-4">¿No ves tu rol?</h3>
                    <p class="text-gray-400 mb-8">Siempre estamos buscando talento. Envíanos tu CV y te contactaremos para futuras oportunidades.</p>
                    <a href="mailto:rrhh@biknova.com" class="text-brand-orange font-bold border-b border-brand-orange pb-1 hover:text-white transition-colors">rrhh@biknova.com</a>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
