<?php 
$pageTitle = 'Expertise';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">Nuestras Áreas de Dominio</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Especialización técnica profunda en las verticales que definen la economía digital moderna.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Area 1 -->
                <a href="web-development.php" class="group p-10 rounded-3xl bg-[#0a0a0a] border border-white/10 hover:border-brand-orange/50 transition-all">
                    <div class="w-16 h-16 bg-brand-orange/10 rounded-2xl flex items-center justify-center text-brand-orange text-3xl mb-8 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-code"></i>
                    </div>
                    <h3 class="text-3xl font-bold mb-4">Web Development</h3>
                    <p class="text-gray-400 mb-6">Plataformas ultra-rápidas con React, Next.js y arquitecturas headless para máximas conversiones.</p>
                    <span class="text-xs font-bold uppercase tracking-widest text-brand-orange border-b border-brand-orange pb-1">Explorar Detalles</span>
                </a>

                <!-- Area 2 -->
                <a href="mobile-apps.php" class="group p-10 rounded-3xl bg-[#0a0a0a] border border-white/10 hover:border-brand-orange/50 transition-all">
                    <div class="w-16 h-16 bg-brand-orange/10 rounded-2xl flex items-center justify-center text-brand-orange text-3xl mb-8 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-mobile-screen"></i>
                    </div>
                    <h3 class="text-3xl font-bold mb-4">Mobile Apps</h3>
                    <p class="text-gray-400 mb-6">Experiencias móviles nativas y cross-platform (Flutter/React Native) con enfoque en UX.</p>
                    <span class="text-xs font-bold uppercase tracking-widest text-brand-orange border-b border-brand-orange pb-1">Explorar Detalles</span>
                </a>

                <!-- Area 3 -->
                <a href="cloud-services.php" class="group p-10 rounded-3xl bg-[#0a0a0a] border border-white/10 hover:border-brand-orange/50 transition-all">
                    <div class="w-16 h-16 bg-brand-orange/10 rounded-2xl flex items-center justify-center text-brand-orange text-3xl mb-8 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-cloud"></i>
                    </div>
                    <h3 class="text-3xl font-bold mb-4">Cloud Services</h3>
                    <p class="text-gray-400 mb-6">Infraestructura escalable en AWS y GCP. Servidores optimizados y despliegues automáticos (DevOps).</p>
                    <span class="text-xs font-bold uppercase tracking-widest text-brand-orange border-b border-brand-orange pb-1">Explorar Detalles</span>
                </a>

                <!-- Area 4 -->
                <a href="ui-ux-design.php" class="group p-10 rounded-3xl bg-[#0a0a0a] border border-white/10 hover:border-brand-orange/50 transition-all">
                    <div class="w-16 h-16 bg-brand-orange/10 rounded-2xl flex items-center justify-center text-brand-orange text-3xl mb-8 group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-palette"></i>
                    </div>
                    <h3 class="text-3xl font-bold mb-4">UI/UX Design</h3>
                    <p class="text-gray-400 mb-6">Diseño centrado en el usuario. Prototipado de alta fidelidad y sistemas de diseño integrales.</p>
                    <span class="text-xs font-bold uppercase tracking-widest text-brand-orange border-b border-brand-orange pb-1">Explorar Detalles</span>
                </a>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
