<?php
// PHP Header Component
?>
<!DOCTYPE html>
<html lang="es" class="scroll-smooth">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' | Biknova' : 'Biknova - Soluciones Digitales Globales'; ?></title>
    <meta name="description"
        content="Biknova Soluciones Integrales SAS: Agencia de desarrollo de software premium, diseño web y apps móviles.">

    <!-- Libraries -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;700;900&display=swap" rel="stylesheet">
    <link rel="icon" type="image/png" href="logo.png">
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- PDF & Flipbook (Conditional Load) -->
    <?php if (isset($loadFlipbook)): ?>
    <script src="https://cdn.jsdelivr.net/npm/page-flip/dist/js/page-flip.browser.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
    </script>
    <?php endif; ?>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        brand: {
                            orange: '#ff6600',
                            dark: '#050505',
                            black: '#000000',
                            gray: '#1a1a1a',
                            surface: '#0f0f0f'
                        }
                    },
                    fontFamily: {
                        sans: ['Outfit', 'sans-serif'],
                    },
                    backgroundImage: {
                        'hero-pattern': "radial-gradient(circle at 50% 50%, rgba(255, 102, 0, 0.08) 0%, transparent 50%)",
                        'grid-pattern': "linear-gradient(rgba(255, 255, 255, 0.03) 1px, transparent 1px), linear-gradient(90deg, rgba(255, 255, 255, 0.03) 1px, transparent 1px)"
                    },
                    animation: {
                        'marquee': 'marquee 30s linear infinite',
                        'fade-in-up': 'fadeInUp 0.8s ease-out forwards',
                        'pulse-glow': 'pulseGlow 2s infinite',
                    },
                    keyframes: {
                        marquee: {
                            '0%': { transform: 'translateX(0%)' },
                            '100%': { transform: 'translateX(-100%)' },
                        },
                        fadeInUp: {
                            '0%': { opacity: '0', transform: 'translateY(20px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' },
                        },
                        pulseGlow: {
                            '0%, 100%': { boxShadow: '0 0 15px rgba(255, 102, 0, 0.5)' },
                            '50%': { boxShadow: '0 0 25px rgba(255, 102, 0, 0.8)' },
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .glass {
            background: rgba(20, 20, 20, 0.7);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.08);
        }

        .logo-white {
            filter: brightness(0) invert(1);
        }

        /* Flipbook Styles */
        .stf__wrapper {
            background: transparent !important;
        }

        .flip-book {
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.5);
        }

        .page {
            background-color: #1a1a1a;
            color: white;
            border: 1px solid #333;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .page-content {
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .page::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: linear-gradient(to right, rgba(0, 0, 0, 0.2) 0%, transparent 10%, transparent 90%, rgba(0, 0, 0, 0.2) 100%);
            pointer-events: none;
        }

        .grid-bg {
            background-size: 30px 30px;
        }

        /* Accordion Transition */
        .accordion-content {
            transition: max-height 0.3s ease-out, opacity 0.3s ease-out;
            max-height: 0;
            overflow: hidden;
            opacity: 0;
        }

        .accordion-content.active {
            opacity: 1;
        }

        /* Gradient Button */
        .btn-premium {
            background: linear-gradient(135deg, #ff6600 0%, #ff8c00 100%);
            position: relative;
            overflow: hidden;
            z-index: 1;
        }

        .btn-premium::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 0%;
            height: 100%;
            background: rgba(255, 255, 255, 0.2);
            z-index: -1;
            transition: width 0.3s ease;
            transform: skewX(-20deg);
        }

        .btn-premium:hover::before {
            width: 150%;
        }
    </style>
</head>

<body class="bg-brand-black text-white antialiased overflow-x-hidden selection:bg-brand-orange selection:text-white">

    <!-- Navbar -->
    <nav class="fixed w-full z-50 transition-all duration-300 bg-brand-black/90 backdrop-blur-md border-b border-white/5"
        id="navbar">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-20 md:h-24 transition-all duration-300" id="nav-container">
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="index.php" class="flex items-center gap-3 group">
                        <div class="relative w-32 md:w-40 transition-all">
                            <img src="logo.png" alt="Biknova"
                                class="w-full h-auto object-contain logo-white transition-transform duration-300 group-hover:scale-105">
                        </div>
                    </a>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:block">
                    <div class="ml-10 flex items-center space-x-10">
                        <a href="index.php#inicio"
                            class="text-sm font-bold uppercase tracking-widest text-gray-400 hover:text-brand-orange transition-colors">Inicio</a>
                        <a href="index.php#servicios"
                            class="text-sm font-bold uppercase tracking-widest text-gray-400 hover:text-brand-orange transition-colors">Servicios</a>
                        <a href="portafolio.php"
                            class="text-sm font-bold uppercase tracking-widest text-gray-400 hover:text-brand-orange transition-colors">Portafolio</a>
                        <a href="nosotros.php"
                            class="text-sm font-bold uppercase tracking-widest text-gray-400 hover:text-brand-orange transition-colors">Nosotros</a>
                        <a href="index.php#contacto"
                            class="btn-premium px-8 py-3 rounded-full text-xs font-black uppercase tracking-[0.2em] text-white shadow-[0_0_20px_rgba(255,102,0,0.4)] hover:shadow-[0_0_30px_rgba(255,102,0,0.6)] transition-all transform hover:-translate-y-0.5">
                            Cotizar Proyecto
                        </a>
                    </div>
                </div>

                <!-- Mobile menu button -->
                <div class="md:hidden flex items-center">
                    <button id="mobile-menu-btn" class="w-12 h-12 flex items-center justify-center text-white focus:outline-none">
                        <div class="relative w-6 h-5">
                            <span id="bar-1" class="absolute w-full h-0.5 bg-white rounded-full transition-all duration-300 top-0"></span>
                            <span id="bar-2" class="absolute w-full h-0.5 bg-white rounded-full transition-all duration-300 top-2"></span>
                            <span id="bar-3" class="absolute w-full h-0.5 bg-white rounded-full transition-all duration-300 top-4"></span>
                        </div>
                    </button>
                </div>
            </div>
        </div>

    </nav>

    <!-- Mobile Menu Overlay (Solid & High Z-Index) -->
    <div class="fixed inset-0 z-[9999] bg-black invisible opacity-0 transition-all duration-500 overflow-hidden flex flex-col items-center justify-center" id="mobile-menu">
        
        <!-- Pattern & Glow (Decorative - Non-blocking) -->
        <div class="absolute inset-0 bg-grid-pattern opacity-10 pointer-events-none"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-brand-orange/20 blur-[150px] rounded-full pointer-events-none"></div>
        
        <!-- Close Button (Now on top with high z-index) -->
        <button id="mobile-close-btn" class="absolute top-8 right-8 w-12 h-12 flex items-center justify-center text-white text-5xl hover:text-brand-orange transition-all z-50">
            <i class="fa-solid fa-xmark"></i>
        </button>

        <div class="relative z-10 flex flex-col items-center gap-10 px-6 text-center">
            <div class="mb-4">
                <img src="logo.png" alt="Biknova" class="w-40 logo-white">
            </div>
            
            <nav class="flex flex-col items-center gap-6">
                <a href="index.php#inicio" class="mobile-link text-4xl font-black uppercase tracking-tighter hover:text-brand-orange transition-all">Inicio</a>
                <a href="index.php#servicios" class="mobile-link text-4xl font-black uppercase tracking-tighter hover:text-brand-orange transition-all">Servicios</a>
                <a href="portafolio.php" class="mobile-link text-4xl font-black uppercase tracking-tighter hover:text-brand-orange transition-all">Portafolio</a>
                <a href="nosotros.php" class="mobile-link text-4xl font-black uppercase tracking-tighter hover:text-brand-orange transition-all">Nosotros</a>
            </nav>
            
            <div class="h-px w-24 bg-white/20"></div>
            
            <a href="index.php#contacto"
                class="btn-premium px-12 py-5 rounded-2xl text-xl font-black uppercase tracking-widest text-white shadow-2xl hover:scale-105 transition-transform">
                <i class="fa-solid fa-paper-plane mr-2"></i> Cotizar
            </a>
        </div>
    </div>

<style>
    /* Links slightly dimmed to highlight hover */
    .mobile-link {
        color: rgba(255, 255, 255, 0.6);
    }
    .mobile-link:hover {
        color: #ffffff;
        letter-spacing: 0.05em;
    }
    
    /* Menu Active State */
    #mobile-menu.active {
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    /* Hamburger Menu Animation */
    .hamburger-active #bar-1 { transform: translateY(8px) rotate(45deg); }
    .hamburger-active #bar-2 { opacity: 0; }
    .hamburger-active #bar-3 { transform: translateY(-8px) rotate(-45deg); }
</style>
