<?php 
$pageTitle = 'Home';
$loadFlipbook = true;
include 'includes/header.php';
?>

    <!-- Hero Section -->
    <header id="inicio" class="relative min-h-screen flex items-center pt-32 overflow-hidden bg-brand-black">
        <div class="absolute inset-0 grid-bg bg-grid-pattern opacity-20 pointer-events-none"></div>
        <div
            class="absolute top-1/4 right-0 w-[500px] h-[500px] bg-brand-orange/20 filter blur-[100px] rounded-full pointer-events-none animate-pulse">
        </div>
        <div
            class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 w-full flex flex-col lg:flex-row items-center gap-16">
            <div class="lg:w-1/2">
                <div
                    class="inline-flex items-center gap-2 px-3 py-1 rounded-full border border-white/10 bg-white/5 mb-8">
                    <span class="w-1.5 h-1.5 rounded-full bg-brand-orange"></span>
                    <span class="text-xs font-semibold tracking-widest text-gray-300 uppercase">Innovación v2.0</span>
                </div>
                <h1 class="text-5xl lg:text-7xl font-bold tracking-tight leading-none mb-6">
                    <span class="block text-white">Forjamos el</span>
                    <span class="text-transparent bg-clip-text bg-gradient-to-r from-brand-orange to-white">Futuro Digital.</span>
                </h1>
                <p class="text-lg text-gray-400 mb-10 leading-relaxed max-w-lg">Transformamos ideas complejas en
                    software de alto rendimiento, experiencias web inmersivas y estrategias de marketing que dominan
                    mercados.</p>
                <div class="flex flex-wrap gap-4">
                    <a href="portafolio.php"
                        class="btn-premium px-8 py-4 rounded-xl font-bold uppercase tracking-wider text-white shadow-[0_0_20px_rgba(255,102,0,0.3)] hover:scale-105 transition-transform">
                        Ver Portafolio
                    </a>
                    <a href="#servicios"
                        class="px-8 py-4 bg-transparent border border-white/20 text-white font-bold uppercase tracking-wider rounded-xl hover:bg-white/5 transition-all">
                        Explorar Servicios
                    </a>
                </div>
            </div>

            <div class="lg:w-1/2 relative hidden lg:flex justify-center items-center">
                <div class="relative z-10 rounded-2xl overflow-hidden shadow-2xl group">
                    <img src="hero2.png" alt="Soluciones Digitales Biknova"
                        class="w-full h-auto max-h-[500px] object-contain opacity-90 group-hover:opacity-100 transition-opacity rounded-2xl">
                    <!-- Shine effect -->
                    <div
                        class="absolute inset-0 bg-gradient-to-tr from-white/5 to-transparent opacity-0 group-hover:opacity-20 transition-opacity duration-300">
                    </div>
                </div>
                <!-- Glow behind -->
                <div
                    class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-3/4 h-3/4 bg-brand-orange/20 blur-[100px] -z-10 animate-pulse">
                </div>
            </div>
        </div>
    </header>

    <!-- Trusted Technologies (Refined Infinite Loop) -->
    <div class="py-12 bg-black border-y border-white/5 relative overflow-hidden">
        <div class="max-w-7xl mx-auto px-4 mb-6">
            <p class="text-center text-xs font-bold uppercase tracking-[0.3em] text-gray-500">Potenciado por Tecnología de Punta</p>
        </div>
        <div class="flex overflow-hidden group">
            <!-- Set 1 -->
            <div class="flex animate-marquee shrink-0 items-center gap-24 md:gap-40 px-12 min-w-full justify-around">
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-react text-4xl"></i> <span class="text-xl font-bold tracking-tight">React</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-python text-4xl"></i> <span class="text-xl font-bold tracking-tight">Python</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-node-js text-4xl"></i> <span class="text-xl font-bold tracking-tight">Node.js</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-aws text-4xl"></i> <span class="text-xl font-bold tracking-tight">AWS</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-google text-4xl"></i> <span class="text-xl font-bold tracking-tight">Google Cloud</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-docker text-4xl"></i> <span class="text-xl font-bold tracking-tight">Docker</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-solid fa-database text-4xl"></i> <span class="text-xl font-bold tracking-tight">SQL</span>
                </div>
            </div>
            <!-- Set 2 (The duplicate) -->
            <div class="flex animate-marquee shrink-0 items-center gap-24 md:gap-40 px-12 min-w-full justify-around" aria-hidden="true">
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-react text-4xl"></i> <span class="text-xl font-bold tracking-tight">React</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-python text-4xl"></i> <span class="text-xl font-bold tracking-tight">Python</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-node-js text-4xl"></i> <span class="text-xl font-bold tracking-tight">Node.js</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-aws text-4xl"></i> <span class="text-xl font-bold tracking-tight">AWS</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-google text-4xl"></i> <span class="text-xl font-bold tracking-tight">Google Cloud</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-brands fa-docker text-4xl"></i> <span class="text-xl font-bold tracking-tight">Docker</span>
                </div>
                <div class="flex-shrink-0 flex items-center gap-4 text-gray-600 hover:text-white transition-colors opacity-60 hover:opacity-100 duration-500 cursor-default">
                    <i class="fa-solid fa-database text-4xl"></i> <span class="text-xl font-bold tracking-tight">SQL</span>
                </div>
            </div>
        </div>
        <!-- Gradient Overlays -->
        <div class="absolute inset-y-0 left-0 w-32 bg-gradient-to-r from-black via-black/80 to-transparent z-10 pointer-events-none"></div>
        <div class="absolute inset-y-0 right-0 w-32 bg-gradient-to-l from-black via-black/80 to-transparent z-10 pointer-events-none"></div>
    </div>

    <!-- Product Spotlight: Zaha360 -->
    <section class="py-24 bg-brand-surface relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-3xl rounded-l-full pointer-events-none">
        </div>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="flex flex-col lg:flex-row items-center gap-16">
                <!-- Content -->
                <div class="lg:w-1/2">
                    <div
                        class="inline-flex items-center gap-2 px-3 py-1 rounded-full border border-brand-orange/30 bg-brand-orange/10 mb-6">
                        <span class="w-2 h-2 rounded-full bg-brand-orange animate-pulse"></span>
                        <span class="text-xs font-bold tracking-widest text-brand-orange uppercase">Producto Estrella</span>
                    </div>
                    <img src="https://zaha360.com/img/zaha-logo-blanco.png" alt="" style='width:200px;height:auto;'> 
                    <p class="text-xl text-gray-400 mb-8 leading-relaxed">
                        El primer sistema operativo Horeca & Retail nacido en La Guajira para el mundo. Gestione sus
                        ventas, inventarios y personal desde una sola plataforma.
                    </p>
                    <ul class="space-y-4 mb-10">
                        <li class="flex items-center gap-3 text-gray-300">
                            <i class="fa-solid fa-check-circle text-brand-orange"></i>
                            <span>Facturación Electrónica DIAN</span>
                        </li>
                        <li class="flex items-center gap-3 text-gray-300">
                            <i class="fa-solid fa-check-circle text-brand-orange"></i>
                            <span>Control de Inventarios con Recetas</span>
                        </li>
                        <li class="flex items-center gap-3 text-gray-300">
                            <i class="fa-solid fa-check-circle text-brand-orange"></i>
                            <span>KDS (Pantallas de Cocina)</span>
                        </li>
                    </ul>
                    <a href="zaha360.php"
                        class="inline-flex items-center gap-3 px-8 py-4 bg-white text-black rounded-xl font-bold uppercase tracking-wider hover:bg-brand-orange hover:text-white transition-all group">
                        Conocer Zaha360 <i
                            class="fa-solid fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                    </a>
                </div>
                <!-- Visual (Video Shorts Zaha360 - Larger & Optimized) -->
                <div class="lg:w-1/2 w-full flex justify-center">
                    <div class="relative rounded-[3rem] border-[10px] border-[#151515] bg-black shadow-[0_0_50px_rgba(0,0,0,0.5)] overflow-hidden w-full max-w-[380px] aspect-[9/18] group">
                        <!-- Sound Toggle Overlay -->
                        <div id="video-overlay" class="absolute inset-0 z-20 flex flex-col items-center justify-center bg-black/40 group-hover:bg-black/30 transition-all cursor-pointer">
                             <div class="w-24 h-24 bg-brand-orange text-white rounded-full flex items-center justify-center shadow-[0_0_40px_rgba(255,102,0,0.5)] group-hover:scale-110 transition-transform mb-6 animate-pulse">
                                <i id="sound-icon" class="fa-solid fa-volume-xmark text-4xl"></i>
                             </div>
                             <p class="text-white text-sm font-black uppercase tracking-[0.2em] bg-black/60 px-6 py-3 rounded-full backdrop-blur-sm border border-white/10">Activar Sonido</p>
                        </div>

                        <!-- Iframe (Optimized) -->
                        <iframe 
                            id="zaha-video"
                            src="https://www.youtube.com/embed/8IyE2km4wyI?autoplay=1&mute=1&loop=1&playlist=8IyE2km4wyI&controls=0&modestbranding=1&rel=0&enablejsapi=1&iv_load_policy=3" 
                            class="absolute inset-0 w-full h-full object-cover scale-[1.05]"
                            frameborder="0" 
                            allow="autoplay; encrypted-media" 
                            allowfullscreen
                            loading="lazy">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- SERVICES -->
    <section id="servicios" class="py-24 bg-brand-surface">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <span
                    class="text-brand-orange font-bold tracking-[0.2em] uppercase text-sm mb-2 block">Soluciones</span>
                <h2 class="text-4xl md:text-5xl font-bold mb-4">Ecosistema Integral</h2>
                <p class="text-gray-400 max-w-2xl mx-auto">Tecnología de punta aplicada a sus necesidades de negocio.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Service 1 -->
                <div
                    class="group p-8 bg-brand-black border border-white/5 hover:border-brand-orange/50 rounded-2xl transition-all hover:bg-[#080808]">
                    <div
                        class="w-14 h-14 bg-white/5 rounded-xl flex items-center justify-center mb-6 text-brand-orange group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-laptop-code text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Software Factory</h3>
                    <p class="text-sm text-gray-400 leading-relaxed">Desarrollo a medida de sistemas ERP, CRM y
                        plataformas web escalables para alta demanda.</p>
                </div>
                <!-- Service 2 -->
                <div
                    class="group p-8 bg-brand-black border border-white/5 hover:border-brand-orange/50 rounded-2xl transition-all hover:bg-[#080808]">
                    <div
                        class="w-14 h-14 bg-white/5 rounded-xl flex items-center justify-center mb-6 text-brand-orange group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-wand-magic-sparkles text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Diseño UX/UI</h3>
                    <p class="text-sm text-gray-400 leading-relaxed">Interfaces intuitivas y estéticas que maximizan la
                        retención de usuarios y la conversión.</p>
                </div>
                <!-- Service 3 -->
                <div
                    class="group p-8 bg-brand-black border border-white/5 hover:border-brand-orange/50 rounded-2xl transition-all hover:bg-[#080808]">
                    <div
                        class="w-14 h-14 bg-white/5 rounded-xl flex items-center justify-center mb-6 text-brand-orange group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-mobile-screen-button text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Mobile Apps</h3>
                    <p class="text-sm text-gray-400 leading-relaxed">Aplicaciones nativas (iOS/Android) e híbridas con
                        rendimiento superior y diseño fluido.</p>
                </div>
                <!-- Service 4 -->
                <div
                    class="group p-8 bg-brand-black border border-white/5 hover:border-brand-orange/50 rounded-2xl transition-all hover:bg-[#080808]">
                    <div
                        class="w-14 h-14 bg-white/5 rounded-xl flex items-center justify-center mb-6 text-brand-orange group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-bullhorn text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Marketing Digital</h3>
                    <p class="text-sm text-gray-400 leading-relaxed">Estrategias de SEO, SEM y Growth Hacking para
                        posicionar su marca en el mercado digital.</p>
                </div>
                <!-- Service 5 -->
                <div
                    class="group p-8 bg-brand-black border border-white/5 hover:border-brand-orange/50 rounded-2xl transition-all hover:bg-[#080808]">
                    <div
                        class="w-14 h-14 bg-white/5 rounded-xl flex items-center justify-center mb-6 text-brand-orange group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-cloud text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Cloud Solutions</h3>
                    <p class="text-sm text-gray-400 leading-relaxed">Arquitectura e infraestructura en la nube
                        (AWS/Azure) segura, rápida y optimizada.</p>
                </div>
                <!-- Service 6 -->
                <div
                    class="group p-8 bg-brand-black border border-white/5 hover:border-brand-orange/50 rounded-2xl transition-all hover:bg-[#080808]">
                    <div
                        class="w-14 h-14 bg-white/5 rounded-xl flex items-center justify-center mb-6 text-brand-orange group-hover:scale-110 transition-transform">
                        <i class="fa-solid fa-chart-line text-2xl"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-3 text-white">Consultoría IT</h3>
                    <p class="text-sm text-gray-400 leading-relaxed">Auditoría tecnológica y planificación estratégica
                        para la transformación digital de su empresa.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- WHY US (Redesigned Cards) -->
    <section id="nosotros" class="py-24 bg-brand-surface relative overflow-hidden border-t border-white/5">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
                <div>
                    <span
                        class="text-brand-orange font-bold tracking-[0.2em] uppercase text-sm mb-2 block">Filosofía</span>
                    <h2 class="text-4xl font-bold mb-6 text-white leading-tight">Ingeniería que<br>no conoce Fronteras</h2>
                    <p class="text-gray-400 mb-8 leading-relaxed text-lg">
                        En Biknova, no solo escribimos código; diseñamos ecosistemas digitales resilientes. Nuestra obsesión por el detalle es lo que nos diferencia.
                    </p>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                        <div class="p-6 rounded-2xl bg-white/5 border border-white/10 hover:border-brand-orange/30 transition-all">
                            <i class="fa-solid fa-bolt text-3xl text-brand-orange mb-4 block"></i>
                            <h4 class="text-white font-bold mb-2">Velocidad Extrema</h4>
                            <p class="text-sm text-gray-400">Tiempos de respuesta optimizados para el usuario moderno.</p>
                        </div>
                        <div class="p-6 rounded-2xl bg-white/5 border border-white/10 hover:border-brand-orange/30 transition-all">
                            <i class="fa-solid fa-shield-halved text-3xl text-brand-orange mb-4 block"></i>
                            <h4 class="text-white font-bold mb-2">Seguridad Total</h4>
                            <p class="text-sm text-gray-400">Protocolos de encriptado y protección de nivel bancario.</p>
                        </div>
                    </div>
                </div>

                <div class="relative">
                    <!-- Glow decoration -->
                    <div class="absolute -top-20 -right-20 w-64 h-64 bg-brand-orange/10 blur-[100px] rounded-full"></div>
                    
                    <div class="grid grid-cols-1 gap-6 relative z-10">
                        <!-- Card 1: 100% Delivery -->
                        <div class="group relative p-8 rounded-[2rem] bg-gradient-to-br from-[#111] to-black border border-white/10 overflow-hidden hover:scale-[1.02] transition-transform duration-500">
                            <div class="absolute top-0 right-0 p-8 opacity-10 group-hover:opacity-20 transition-opacity">
                                <i class="fa-solid fa-calendar-check text-8xl text-white"></i>
                            </div>
                            <div class="relative z-10">
                                <div class="text-6xl font-black text-transparent bg-clip-text bg-gradient-to-r from-brand-orange to-white mb-2">100%</div>
                                <h3 class="text-2xl font-bold text-white mb-2">A Tiempo</h3>
                                <p class="text-gray-500 max-w-[200px]">Compromiso innegociable con las fechas de entrega acordadas.</p>
                            </div>
                            <div class="mt-8 flex gap-2">
                                <span class="w-12 h-1 bg-brand-orange rounded-full"></span>
                                <span class="w-4 h-1 bg-white/20 rounded-full"></span>
                                <span class="w-4 h-1 bg-white/20 rounded-full"></span>
                            </div>
                        </div>

                         <!-- Card 2: 24/7 Support -->
                         <div class="group relative p-8 rounded-[2rem] bg-gradient-to-br from-[#111] to-black border border-white/10 overflow-hidden hover:scale-[1.02] transition-transform duration-500 md:ml-12">
                            <div class="absolute top-0 right-0 p-8 opacity-10 group-hover:opacity-20 transition-opacity">
                                <i class="fa-solid fa-headset text-8xl text-white"></i>
                            </div>
                            <div class="relative z-10">
                                <div class="text-6xl font-black text-transparent bg-clip-text bg-gradient-to-r from-brand-orange to-white mb-2">24/7</div>
                                <h3 class="text-2xl font-bold text-white mb-2">Soporte Vital</h3>
                                <p class="text-gray-500 max-w-[200px]">Asistencia técnica ininterrumpida para su tranquilidad operativa.</p>
                            </div>
                            <div class="mt-8 flex gap-2">
                                <span class="w-4 h-1 bg-white/20 rounded-full"></span>
                                <span class="w-12 h-1 bg-brand-orange rounded-full"></span>
                                <span class="w-4 h-1 bg-white/20 rounded-full"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- STATS -->
    <section class="py-20 bg-brand-orange relative overflow-hidden">
        <div class="absolute inset-0 bg-black/10"></div>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8 text-center text-white">
                <div>
                    <div class="text-4xl md:text-6xl font-black mb-2 counter" data-target="50">0</div>
                    <div class="text-[10px] md:text-xs font-bold uppercase tracking-widest text-black/70">Proyectos Web</div>
                </div>
                <div>
                    <div class="text-3xl md:text-6xl font-black mb-2 counter" data-target="12000">0</div>
                    <div class="text-[10px] md:text-xs font-bold uppercase tracking-widest text-black/70">Líneas de Código</div>
                </div>
                <div>
                    <div class="text-4xl md:text-6xl font-black mb-2 counter" data-target="15">0</div>
                    <div class="text-[10px] md:text-xs font-bold uppercase tracking-widest text-black/70">Municipios</div>
                </div>
                <div>
                    <div class="text-4xl md:text-6xl font-black mb-2 counter" data-target="99">0</div>
                    <div class="text-[10px] md:text-xs font-bold uppercase tracking-widest text-black/70">Felicidad Cliente</div>
                </div>
            </div>
        </div>
    </section>

    <!-- PORTFOLIO FLIPBOOK -->
    <section id="portafolio" class="py-24 bg-brand-black relative overflow-hidden">
        <div class="absolute top-0 right-0 w-full h-full bg-grid-pattern opacity-10 pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10 flex flex-col items-center">
            <div class="text-center mb-12">
                <span class="text-brand-orange font-bold tracking-widest uppercase text-xs">Experiencia Interactiva</span>
                <h2 class="text-4xl md:text-5xl font-bold mt-2 mb-6">Nuestro Portafolio</h2>
                <p class="text-gray-400 max-w-xl mx-auto">Explore nuestros casos de éxito. Deslice o haga clic en las esquinas.</p>
            </div>
            <div class="relative w-full max-w-4xl h-[500px] md:h-[600px] flex justify-center items-center">
                <div id="flipbook" class="flip-book shadow-2xl relative bg-[#1a1a1a]">
                    <div class="absolute inset-0 flex items-center justify-center text-white" id="flip-loader">
                        <i class="fa-solid fa-spinner fa-spin text-4xl text-brand-orange"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- TESTIMONIALS -->
    <section class="py-24 bg-brand-surface">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl md:text-5xl font-bold mb-16 text-center text-white">Historias de Éxito</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Review 1 -->
                <div class="bg-brand-black p-10 rounded-2xl border border-white/5 relative group hover:border-brand-orange/30 transition-colors">
                    <i class="fa-solid fa-quote-left text-brand-orange text-4xl absolute top-6 left-6 opacity-50"></i>
                    <p class="text-gray-400 mb-8 mt-6 relative z-10 italic leading-relaxed">"Increíble atención al
                        detalle. Nuestra plataforma ahora carga el doble de rápido y las ventas han aumentado un 40%."
                    </p>
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-gray-800 rounded-full flex items-center justify-center text-gray-500 font-bold">CM</div>
                        <div>
                            <div class="font-bold text-white text-sm">Carlos Martínez</div>
                            <div class="text-xs text-gray-500">CEO, RetailTech</div>
                        </div>
                    </div>
                </div>
                <!-- Review 2 -->
                <div class="bg-brand-black p-10 rounded-2xl border border-white/5 relative group hover:border-brand-orange/30 transition-colors">
                    <i class="fa-solid fa-quote-left text-brand-orange text-4xl absolute top-6 left-6 opacity-50"></i>
                    <p class="text-gray-400 mb-8 mt-6 relative z-10 italic leading-relaxed">"Entendieron nuestra visión
                        a la perfección. La app móvil es intuitiva, rápida y luce exactamente como queríamos."</p>
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-gray-800 rounded-full flex items-center justify-center text-gray-500 font-bold">AS</div>
                        <div>
                            <div class="font-bold text-white text-sm">Ana Suárez</div>
                            <div class="text-xs text-gray-500">CMO, TravelGo</div>
                        </div>
                    </div>
                </div>
                <!-- Review 3 -->
                <div class="bg-brand-black p-10 rounded-2xl border border-white/5 relative group hover:border-brand-orange/30 transition-colors">
                    <i class="fa-solid fa-quote-left text-brand-orange text-4xl absolute top-6 left-6 opacity-50"></i>
                    <p class="text-gray-400 mb-8 mt-6 relative z-10 italic leading-relaxed">"Profesionalismo de alto
                        nivel. Cumplieron los plazos estrictos y el soporte post-lanzamiento es excelente."</p>
                    <div class="flex items-center gap-4">
                        <div class="w-12 h-12 bg-gray-800 rounded-full flex items-center justify-center text-gray-500 font-bold">JR</div>
                        <div>
                            <div class="font-bold text-white text-sm">Jorge Ramirez</div>
                            <div class="text-xs text-gray-500">Founder, Logística Norte</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ -->
    <section class="py-24 bg-brand-surface border-t border-white/5" id="faq">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <span class="text-brand-orange font-bold tracking-widest uppercase text-xs mb-2 block">Dudas Resueltas</span>
                <h2 class="text-3xl font-bold mb-4 text-white">Preguntas Frecuentes</h2>
            </div>
            <div class="space-y-4">
                <!-- Q1 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-earth-americas text-brand-orange mr-3"></i> ¿Trabajan con clientes fuera de La Guajira?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Absolutamente. Aunque nuestra base está en el corazón de La Guajira, operamos bajo un modelo 100% digital que nos permite colaborar con empresas en cualquier rincón del mundo, desde Bogotá hasta Europa y Estados Unidos.</p>
                    </div>
                </div>
                <!-- Q2 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-money-bill-wave text-brand-orange mr-3"></i> ¿Qué incluye la consultoría inicial con descuento?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Incluye un diagnóstico técnico profundo, definición de arquitectura, cronograma estimado y presupuesto detallado. Si decides iniciar el desarrollo con nosotros, el costo de la consultoría se abona al valor total del proyecto.</p>
                    </div>
                </div>
                <!-- Q3 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-clock text-brand-orange mr-3"></i> ¿Cuánto tiempo toma desarrollar un proyecto?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Depende de la complejidad. Un sitio web corporativo premium puede tardar 2-4 semanas, mientras que una plataforma compleja o App móvil puede requerir de 2 a 6 meses. Siempre definimos hitos de entrega realistas.</p>
                    </div>
                </div>
                <!-- Q4 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-code text-brand-orange mr-3"></i> ¿Qué tecnologías utilizan en sus desarrollos?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Dominamos tecnologías de vanguardia como React, Node.js, Python, PHP (Laravel), y Flutter para aplicaciones móviles. Seleccionamos el stack tecnológico que mejor se adapte a la escalabilidad y presupuesto de cada cliente.</p>
                    </div>
                </div>
                <!-- Q5 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-file-contract text-brand-orange mr-3"></i> ¿El código fuente será de mi propiedad?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Sí. Al finalizar el proyecto y completar el pago, entregamos el código fuente y los derechos de propiedad intelectual. Usted es dueño total de la solución que construimos para su negocio.</p>
                    </div>
                </div>
                <!-- Q6 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-gears text-brand-orange mr-3"></i> ¿Ofrecen mantenimiento después del lanzamiento?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Sí, ofrecemos planes de soporte y mantenimiento mensual que incluyen actualizaciones de seguridad, corrección de errores, copias de seguridad y optimización técnica continua.</p>
                    </div>
                </div>
                <!-- Q7 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-rocket text-brand-orange mr-3"></i> ¿Qué es Zaha360 y cómo ayuda a mi negocio?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Es nuestro producto estrella: un potente sistema de gestión (ERP) especializado en Horeca y Retail. Centraliza ventas, inventarios, nómina y facturación electrónica en una sola interfaz desde la nube.</p>
                    </div>
                </div>
                <!-- Q8 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-receipt text-brand-orange mr-3"></i> ¿Realizan integraciones de facturación electrónica?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Somos expertos en integraciones con la DIAN en Colombia. Implementamos facturación electrónica, nómina electrónica y documentos equivalentes directamente en su software o mediante Zaha360.</p>
                    </div>
                </div>
                <!-- Q9 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-shield-virus text-brand-orange mr-3"></i> ¿Cómo manejan la seguridad de los datos?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Aplicamos protocolos de seguridad OWASP, encriptación de datos en tránsito y reposo, y utilizamos infraestructuras seguras como AWS y Azure con monitoreo activo 24/7.</p>
                    </div>
                </div>
                <!-- Q10 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-users-gear text-brand-orange mr-3"></i> ¿Qué metodologías de trabajo utilizan?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Utilizamos Metodologías Ágiles (Scrum/Kanban). Esto garantiza entregas parciales constantes, transparencia total en el proceso y la posibilidad de ajustar el rumbo del proyecto según su feedback.</p>
                    </div>
                </div>
                <!-- Q11 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-chart-simple text-brand-orange mr-3"></i> ¿Ofrecen servicios de marketing y SEO?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">Sí. No solo construimos la herramienta técnica, sino que ayudamos a posicionarla. Ofrecemos SEO técnico, gestión de pauta en Google Ads/Meta y estrategias de crecimiento digital.</p>
                    </div>
                </div>
                <!-- Q12 -->
                <div class="border border-white/5 rounded-lg bg-[#111] overflow-hidden group">
                    <button class="accordion-header w-full px-6 py-5 text-left flex justify-between items-center text-white font-bold hover:bg-white/5 transition-colors">
                        <span><i class="fa-solid fa-comments text-brand-orange mr-3"></i> ¿Cómo puedo iniciar un proyecto con Biknova?</span>
                        <i class="fa-solid fa-plus text-brand-orange transition-transform duration-300"></i>
                    </button>
                    <div class="accordion-content bg-black/50 px-6">
                        <p class="py-4 text-gray-400 text-sm border-t border-white/5">El primer paso es agendar una sesión estratégica mediante nuestro botón de WhatsApp. Allí escucharemos su idea, le daremos un pre-diagnóstico y trazaremos la mejor ruta tecnológica para su éxito.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Form Section -->
    <section id="contacto" class="py-24 bg-[#050505] relative overflow-hidden">
        <div class="absolute inset-0 bg-grid-pattern opacity-10 pointer-events-none"></div>
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-start">
                <!-- Text Content -->
                <div class="lg:sticky lg:top-32">
                    <span class="text-brand-orange font-bold tracking-[0.2em] uppercase text-sm mb-4 block">Cotización inmediata</span>
                    <h2 class="text-4xl md:text-6xl font-bold text-white mb-8 leading-tight">¿Listo para<br>hacerlo realidad?</h2>
                    
                    <div class="space-y-6 mb-12">
                        <div class="flex gap-4">
                            <i class="fa-solid fa-check text-brand-orange mt-1"></i>
                            <p class="text-gray-400">Respuesta garantizada en menos de 24 horas.</p>
                        </div>
                        <div class="flex gap-4">
                            <i class="fa-solid fa-check text-brand-orange mt-1"></i>
                            <p class="text-gray-400">Consultoría técnica gratuita incluida.</p>
                        </div>
                        <div class="flex gap-4">
                            <i class="fa-solid fa-check text-brand-orange mt-1"></i>
                            <p class="text-gray-400">Presupuestos adaptados a su escalabilidad.</p>
                        </div>
                    </div>

                    <div class="p-8 rounded-3xl bg-brand-orange/5 border border-brand-orange/20">
                         <p class="text-sm text-gray-400 mb-4 uppercase tracking-widest font-bold">También puede llamarnos</p>
                         <div class="flex items-center gap-4">
                             <a href="https://wa.me/573000000000" class="text-3xl font-black text-white hover:text-brand-orange transition-colors">+57 300 000 0000</a>
                         </div>
                    </div>
                </div>

                <!-- Actual Form -->
                <div class="relative">
                    <div class="absolute inset-0 bg-brand-orange/10 blur-[100px] rounded-full pointer-events-none"></div>
                    <form id="quote-form" class="relative z-10 bg-brand-black border border-white/10 p-8 md:p-12 rounded-[2.5rem] shadow-2xl overflow-hidden glass">
                        <div class="grid grid-cols-1 gap-6">
                            <div>
                                <label class="block text-xs font-bold uppercase tracking-widest text-gray-500 mb-2">Nombre Completo</label>
                                <input type="text" name="nombre" required placeholder="Ej: Juan Pérez" 
                                    class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 text-white placeholder-gray-600 focus:outline-none focus:border-brand-orange focus:ring-1 focus:ring-brand-orange transition-all">
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-xs font-bold uppercase tracking-widest text-gray-500 mb-2">Email Corporativo</label>
                                    <input type="email" name="email" required placeholder="juan@empresa.com" 
                                        class="w-full bg-white/5 border border-white/10 rounded-text-white rounded-2xl px-6 py-4 text-white placeholder-gray-600 focus:outline-none focus:border-brand-orange focus:ring-1 focus:ring-brand-orange transition-all">
                                </div>
                                <div>
                                    <label class="block text-xs font-bold uppercase tracking-widest text-gray-500 mb-2">WhatsApp / Teléfono</label>
                                    <input type="tel" name="whatsapp" required placeholder="+57 300..." 
                                        class="w-full bg-white/5 border border-white/10 rounded-text-white rounded-2xl px-6 py-4 text-white placeholder-gray-600 focus:outline-none focus:border-brand-orange focus:ring-1 focus:ring-brand-orange transition-all">
                                </div>
                            </div>
                            <div>
                                <label class="block text-xs font-bold uppercase tracking-widest text-gray-500 mb-2">Cuéntenos su Proyecto</label>
                                <textarea name="proyecto" required rows="4" placeholder="Describa brevemente lo que necesita..." 
                                    class="w-full bg-white/5 border border-white/10 rounded-2xl px-6 py-4 text-white placeholder-gray-600 focus:outline-none focus:border-brand-orange focus:ring-1 focus:ring-brand-orange transition-all"></textarea>
                            </div>
                            <button type="submit" id="submit-btn" class="btn-premium w-full py-5 rounded-2xl text-lg font-black uppercase tracking-widest text-white shadow-2xl hover:scale-[1.02] transition-all flex items-center justify-center gap-3">
                                <span>Enviar Solicitud</span>
                                <i class="fa-solid fa-paper-plane"></i>
                            </button>
                            <p class="text-[10px] text-center text-gray-500 uppercase tracking-widest">Al enviar acepta nuestras políticas de tratamiento de datos.</p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
