<?php 
$pageTitle = 'UI/UX Design';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">UI/UX Design</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Diseñamos interfaces que cautivan y flujos que convierten. El balance perfecto entre arte y funcionalidad.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16 items-center">
                <div class="relative group">
                    <div class="absolute inset-0 bg-brand-orange/20 blur-[80px] rounded-full group-hover:bg-brand-orange/30 transition-all"></div>
                    <div class="relative z-10 rounded-2xl overflow-hidden border border-white/10 shadow-2xl">
                        <img src="https://images.unsplash.com/photo-1586717791821-3f44a563eb4c?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" alt="Design Process" class="w-full h-auto grayscale group-hover:grayscale-0 transition-all duration-700">
                    </div>
                </div>
                <div>
                    <h2 class="text-3xl font-bold mb-6 text-white">Estrategia Centrada en el Humano</h2>
                    <p class="text-gray-400 text-lg leading-relaxed mb-8">Nuestros diseños no solo son "bonitos"; están fundamentados en la psicología del usuario y en datos de interacción reales.</p>
                    
                    <div class="space-y-6">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-lg bg-brand-orange/10 flex items-center justify-center text-brand-orange font-bold italic">F</div>
                            <span class="font-bold">Prototipado en Figma</span>
                        </div>
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-lg bg-brand-orange/10 flex items-center justify-center text-brand-orange font-bold italic">A</div>
                            <span class="font-bold">Interacciones Atómicas</span>
                        </div>
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-lg bg-brand-orange/10 flex items-center justify-center text-brand-orange font-bold italic">S</div>
                            <span class="font-bold">Sistemas de Diseño (Design Systems)</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
