<?php 
$pageTitle = 'Zaha360 - Gestión Integral';
include 'includes/header.php';
?>

    <!-- Hero Product -->
    <section class="relative min-h-screen pt-48 pb-20 flex items-center overflow-hidden">
        <div class="absolute inset-0 bg-grid-pattern opacity-10"></div>
        <div class="absolute top-0 right-0 w-3/4 h-3/4 bg-brand-orange/10 filter blur-[100px] pointer-events-none"></div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full grid grid-cols-1 lg:grid-cols-2 gap-16 items-center relative z-10">
            <div>
                <div class="inline-block px-4 py-1 rounded-full border border-brand-orange/30 bg-brand-orange/10 text-brand-orange text-xs font-bold uppercase tracking-widest mb-6">
                    Producto Estrella
                </div>
                <h1 class="text-5xl md:text-7xl font-black leading-tight mb-6">
                    Control Total.<br>
                    <span class="text-transparent bg-clip-text bg-gradient-to-r from-brand-orange to-white">Tiempo Real.</span>
                </h1>
                <p class="text-xl text-gray-400 mb-8 leading-relaxed">
                    El sistema operativo definitivo para el sector Horeca y Retail. POS, Inventarios, Cocina y
                    Administración unificados en una sola plataforma en la nube.
                </p>
                <div class="flex flex-wrap gap-4">
                    <a href="https://wa.me/573000000000?text=Hola,%20quiero%20una%20demo%20de%20Zaha360"
                        class="btn-premium px-8 py-4 rounded-xl font-bold uppercase tracking-wider text-white shadow-[0_0_20px_rgba(255,102,0,0.4)]">
                        Solicitar Demo
                    </a>
                    <a href="#features"
                        class="px-8 py-4 border border-white/10 rounded-xl font-bold uppercase tracking-wider text-white hover:bg-white/5 transition-colors">
                        Características
                    </a>
                </div>

                <div class="mt-12 flex items-center gap-8 text-sm text-gray-500 font-medium">
                    <div class="flex items-center gap-2">
                        <i class="fa-solid fa-cloud"></i> 100% Cloud
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="fa-solid fa-mobile-screen"></i> Multi-dispositivo
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="fa-solid fa-store"></i> Horeca Expert
                    </div>
                </div>
            </div>

            <div class="relative">
                <div class="aspect-square relative rounded-3xl overflow-hidden border border-white/10 shadow-2xl bg-[#111] group">
                    <div class="absolute inset-0 bg-gradient-to-br from-[#1a1a1a] to-black flex items-center justify-center p-12">
                        <!-- Abstract UI Representation -->
                        <div class="w-full h-full border border-white/5 rounded-xl flex flex-col overflow-hidden relative">
                            <div class="h-12 border-b border-white/5 bg-white/5 flex items-center px-4 justify-between">
                                <div class="flex gap-2">
                                    <div class="w-3 h-3 rounded-full bg-red-500"></div>
                                    <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                                    <div class="w-3 h-3 rounded-full bg-green-500"></div>
                                </div>
                                <div class="text-[10px] text-gray-500 uppercase font-bold">Zaha360 Dashboard</div>
                            </div>
                            <div class="flex-1 flex">
                                <div class="w-20 border-r border-white/5 bg-white/[0.02]"></div>
                                <div class="flex-1 p-6 grid grid-cols-2 gap-4">
                                    <div class="bg-brand-orange/20 rounded-lg h-32 border border-brand-orange/30 animate-pulse"></div>
                                    <div class="bg-white/5 rounded-lg h-32"></div>
                                    <div class="col-span-2 bg-white/5 rounded-lg h-24"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="absolute -right-8 top-1/2 -translate-y-1/2 bg-white/10 backdrop-blur-xl border border-white/20 p-4 rounded-xl shadow-2xl animate-fade-in-up">
                    <div class="text-xs text-brand-orange font-bold uppercase mb-1">Ventas Hoy</div>
                    <div class="text-2xl font-black">$ 4.2M</div>
                    <div class="text-xs text-green-400 mt-1"><i class="fa-solid fa-arrow-trend-up"></i> +12%</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Grid -->
    <section id="features" class="py-24 bg-brand-surface">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-20">
                <h2 class="text-3xl md:text-5xl font-bold mb-6">Un Ecosistema Completo</h2>
                <p class="text-gray-400 max-w-2xl mx-auto">Diseñado para cubrir cada rol operativo de su negocio de manera fluida.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="p-8 rounded-2xl bg-white/5 border border-white/10 hover:bg-white/10 transition-colors">
                    <div class="w-12 h-12 bg-blue-500/20 text-blue-400 flex items-center justify-center rounded-lg text-2xl mb-6">
                        <i class="fa-solid fa-cash-register"></i>
                    </div>
                    <h3 class="text-xl font-bold text-white mb-3">POS Inteligente</h3>
                    <p class="text-gray-400 text-sm leading-relaxed">Facturación electrónica rápida, gestión de mesas, cuentas divididas y múltiples métodos de pago sin fricción.</p>
                </div>
                <div class="p-8 rounded-2xl bg-white/5 border border-white/10 hover:bg-white/10 transition-colors">
                    <div class="w-12 h-12 bg-orange-500/20 text-orange-400 flex items-center justify-center rounded-lg text-2xl mb-6">
                        <i class="fa-solid fa-utensils"></i>
                    </div>
                    <h3 class="text-xl font-bold text-white mb-3">KDS (Cocina)</h3>
                    <p class="text-gray-400 text-sm leading-relaxed">Comandas digitales directas a cocina y bar. Controle tiempos de preparación y reduzca errores humanos.</p>
                </div>
                <div class="p-8 rounded-2xl bg-white/5 border border-white/10 hover:bg-white/10 transition-colors">
                    <div class="w-12 h-12 bg-emerald-500/20 text-emerald-400 flex items-center justify-center rounded-lg text-2xl mb-6">
                        <i class="fa-solid fa-boxes-stacked"></i>
                    </div>
                    <h3 class="text-xl font-bold text-white mb-3">Inventarios</h3>
                    <p class="text-gray-400 text-sm leading-relaxed">Control en tiempo real de insumos, recetas estándar y alertas de stock bajo. Rentabilidad asegurada.</p>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
